<?php
include "../connection.php";

header('Content-Type: application/json');

$response = [
    "error" => true,
    "message" => "Something went wrong, try again later!",
];

try {
    if (!isset($_POST["userName"], $_POST["password"], $_POST["isFirst"])) {
        throw new Exception("Invalid input");
    }

    $userName = $_POST["userName"];
    $password = $_POST["password"];
    $isFirst = $_POST["isFirst"];

    $checkIfUserExistStmt = $conn->prepare("SELECT id FROM admin WHERE user_name = ? and password = ?");
    $checkIfUserExistStmt->bind_param("ss", $userName, $password);
    $checkIfUserExistStmt->execute();
    $checkIfUserExistStmt->store_result();

    if ($checkIfUserExistStmt->num_rows > 0) {
      
        $checkIfUserExistStmt->bind_result($id); 
        $checkIfUserExistStmt->fetch(); 
        
        if($isFirst == true){
            $deviceId = $_POST["deviceId"];
            $token = $_POST["token"];
            // $updateStmt = $conn->prepare("UPDATE admin SET token = ? WHERE user_name = ?");
            // $updateStmt->bind_param("ss", $token, $userName);

            $updateStmt = $conn->prepare("INSERT INTO admin_tokens (admin_id, token, device_id) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE token = ?");
            $updateStmt->bind_param("isss", $id, $token, $deviceId, $token);

            $updateResult = $updateStmt->execute();
            if ($updateResult) {
                $response = [
                    "error" => false,
                    "message" => "Logged In"
                ];
            }else{
                $response = [
                    "error" => false,
                    "message" => "Failed to update token, try again later!"
                ];
            }
        }else{
            $response = [
                "error" => false,
                "message" => "Logged In"
            ];
        }
       
            
    } else {
        $response = [
            "error" => true,
            "message" => "Incorrect User Name or Password!"
        ];
    }

    $checkIfUserExistStmt->close();
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
?>