<?php
include "../connection.php";
include_once 'send_mail.php';

header('Content-Type: application/json');
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
ini_set('display_errors', 0); 
ini_set('max_execution_time', 300);

$response = [
    "error" => true,
    "message" => "Something went wrong, try again later!"
];

try {

    if (!isset($_POST["userName"], $_POST["password"], $_POST["url"], $_POST["planId"])) {
        throw new Exception("Invalid input");
    }

    $userName = $_POST["userName"];
    $password = $_POST["password"];
    $url = $_POST["url"];
    $planId = $_POST["planId"];
    $uid = $_POST["uid"];
   
    $checkIfExistStmt = $conn->prepare("SELECT id FROM user_credentials WHERE acc_username = ? AND password = ? AND upid = ? AND url = ?");
    $checkIfExistStmt->bind_param("ssss", $userName, $password,$planId, $url);
    $checkIfExistStmt->execute();
    $checkIfExistStmt->store_result();

    if ($checkIfExistStmt->num_rows > 0) {
    
        $response = [
            "error" => false,
            "message" => "User with such credentials already exist!"
        ];
   
    }else{
        try {
            $trimUrl = trim($url);
            
            // Check if the trimmed URL is empty or not a valid URL format
            if (empty($trimUrl) || !filter_var($trimUrl, FILTER_VALIDATE_URL)) {
                $response = [
                    "error" => true,
                    "message" => "Invalid URL provided.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            $json_url = $trimUrl . "/player_api.php?username=" . $userName . "&password=" . $password . "&ac";
        
            // Validate the constructed URL
            if (!filter_var($json_url, FILTER_VALIDATE_URL)) {
                $response = [
                    "error" => true,
                    "message" => "Invalid URL provided.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            // Attempt to get headers
            $headers = @get_headers($json_url); // Use @ to suppress warnings
        
            // Check if headers were fetched successfully
            if ($headers === false || strpos($headers[0], '200') === false) {
                $response = [
                    "error" => true,
                    "message" => "The credentials you provided do not exist or are unavailable.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            // Fetch JSON data
            $jsonData = @file_get_contents($json_url); // Use @ to suppress warnings
            // Check if data was fetched successfully
            if ($jsonData === false) {
                $response = [
                    "error" => true,
                    "message" => "Failed to fetch data from the API.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            $data = json_decode($jsonData, true);
        
            // Check if decoding was successful and if required keys exist
            if (is_null($data) || !isset($data['user_info']) || !isset($data['server_info'])) {
                $response = [
                    "error" => true,
                    "message" => "Invalid response.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            // Extract user info from the data
            $userInfo = $data['user_info'];
            $createdAt = $userInfo['created_at'] ?? null; // Use null coalescing operator to avoid undefined index notice
            $expiryDate = $userInfo['exp_date'] ?? null;
            $isTrial = $userInfo['is_trial'] ?? null;
        
            $selTimeZone = $data['server_info']['timezone'];
            // Set the timezone
            $timezone = new DateTimeZone($selTimeZone);
        
            // Convert created_at timestamp to a readable format
            $createdAtDateTime = new DateTime("@$createdAt"); // Create DateTime object from timestamp
            $createdAtDateTime->setTimezone($timezone); // Set the desired timezone
            $createdAtFormatted = $createdAtDateTime->format('Y-m-d h:i:s A'); 
        
            // Convert exp_date timestamp to a readable format
            $expiryDateTime = new DateTime("@$expiryDate"); // Create DateTime object from timestamp
            // $expiryDateTime->setTimezone($timezone); // Set the desired timezone
            // $expiryDateTime->setTimezone("UTC");
            $expiryDateTime->setTimezone(new DateTimeZone("UTC"));
            $expiryDateFormatted = $expiryDateTime->format('Y-m-d h:i:s A'). ' UTC'; // 12-hour format
            
            // Check if any required fields are null before proceeding
            if (is_null($createdAt) || is_null($expiryDate) || is_null($isTrial)) {
                $response = [
                    "error" => true,
                    "message" => "One or more required fields are missing.",
                ];
                exit(json_encode($response)); // Return the response in JSON format
            }
        
            $emailBody = createEmailBody($userName, $password, $url, $expiryDateFormatted);
            $receiverName = $_POST["receiverName"];
            $receiverEmail = $_POST["receiverEmail"];
            $subject = 'Your IPTV Server Credentials';
        
            $emailResponse = sendEmail($receiverName, $receiverEmail, $subject, $emailBody, $conn);
            
            if ($emailResponse['error']) {
                $response = [
                    "error" => true,
                    "message" => $emailResponse['message'],
                ];
                exit(json_encode($response)); // Return the response in JSON format
            } else {
                $registerUserStmt = $conn->prepare("INSERT INTO user_credentials (upid, acc_username, password, url, is_trial, created_at, exp_date) VALUES (?, ?, ?, ?, ?, ?, ?)");
                $registerUserStmt->bind_param("sssssss", $planId, $userName, $password, $url, $isTrial, $createdAt, $expiryDate);
            
                if ($registerUserStmt->execute()) {
                    $lastInsertId = $conn->insert_id;
                    $planStatus = "Accepted";
                    $updateStmt = $conn->prepare("UPDATE selected_plan SET plan_status = ? WHERE id = ?");
                    $updateStmt->bind_param("si", $planStatus, $planId);
                    $updateResult = $updateStmt->execute();
                    if ($updateResult) {
                        $response = [
                            "error" => false,
                            "message" => "User Credentials have been sent via email!",
                        ];
                        exit(json_encode($response)); // Return the response in JSON format
                    } else {
                        throw new Exception("Failed to send credentials at the moment, try again later!");
                    }
                } else {
                    throw new Exception("Failed to send credentials at the moment, try again later!");
                }
                $registerUserStmt->close();
            }
        
        } catch (Exception $e) {
            // Capture any exception messages and return as response
            $response = [
                "error" => true,
                "message" => $e->getMessage(),
            ];
            exit(json_encode($response)); // Return the response in JSON format
        }
    }
    $checkIfExistStmt->close();
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}

function createEmailBody($username, $password, $url, $expiryDate) {
    $body = '
    <html>
    <head>
        <title>IPTV Server Credentials</title>
        <style>
            body { font-family: Arial, sans-serif; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; }
            .header { text-align: center; }
            .footer { font-size: 12px; color: #888; text-align: center; margin-top: 20px; }
            .credentials { background-color: #f9f9f9; padding: 10px; border: 1px solid #eaeaea; border-radius: 4px; }
            .highlight { font-weight: bold; color: #333; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>IPTV Server Credentials</h1>
            </div>
            <p>Dear Client,</p>
            <p>We are pleased to provide you with your IPTV server credentials. Please find the details below:</p>
            <div class="credentials">
                <p><span class="highlight">Username:</span> ' . htmlspecialchars($username) . '</p>
                <p><span class="highlight">Password:</span> ' . htmlspecialchars($password) . '</p>
                <p><span class="highlight">URL:</span> ' . htmlspecialchars($url) . '</p>
            </div>
            <p>Your credentials are valid until <strong>' . htmlspecialchars($expiryDate) . '</strong>.</p>
            <p class="confidential">Please keep your credentials confidential and do not share them with anyone.</p>
            <p>Note: For security purposes, your account is limited to one active session at a time. Attempting to log in on a different device while logged in elsewhere will result in a temporary 30-minute lockout. To avoid interruptions, please log out from the current device before accessing your account on a new device.</p>
            <p>If you have any questions or need assistance, feel free to reach out.</p>
            <p>Best regards,<br>StarsN IPTV </p>
            <div class="footer">
                <p>&copy; ' . date('Y') . ' StarsN IPTV. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ';
    
    return $body;
}
?>
