<?php
include "../connection.php";

if (isset($_POST["limit"])
 && isset($_POST["offset"])) {
    $limit = $_POST["limit"];
    $page = $_POST["offset"];

    $offset = ($page - 1) * $limit;

    $stmt = $conn->prepare("SELECT 
    u.id AS userId, 
    ucre.id AS credentialId, 
    sp.id AS planId,
    u.email, 
    u.user_name, 
    u.token, 
    sp.plan_type, 
    sp.plan_duration, 
    ucre.acc_username, 
    ucre.password, 
    ucre.url, 
    ucre.is_trial, 
    ucre.created_at, 
    ucre.exp_date 
    FROM 
        selected_plan sp
    LEFT JOIN 
        users u ON sp.uid = u.id
    LEFT JOIN 
        user_credentials ucre ON ucre.upid = sp.id
    WHERE
        ucre.exp_date > UNIX_TIMESTAMP() AND sp.plan_status = 'Accepted'
    ORDER BY 
        ucre.created_at DESC
    LIMIT ? OFFSET ?;");

    $stmt->bind_param("ii", $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        sendResponse(false, "All Active users fetched", $data);
    } else {
        sendResponse(true, "No Active Users!", null);
    }
    $stmt->close();
}else{
    sendResponse(true, "Invalid request type", null);
}

function sendResponse($error, $message, $data) {
    $response = [
        'error' => $error,
        'message' => $message,
        'resultData' => $data
    ];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}
?>