<?php
include "../connection.php";

if (isset($_POST["limit"])
 && isset($_POST["offset"])) {
    $limit = $_POST["limit"];
    $page = $_POST["offset"];

    $offset = ($page - 1) * $limit;

    $stmt = $conn->prepare("SELECT 
    u.id AS userId, 
    u.email, 
    u.user_name, 
    u.token
    FROM 
        users u
    LEFT JOIN 
        selected_plan sp ON u.id = sp.uid 
    LEFT JOIN 
        user_credentials ucre ON ucre.upid = sp.id
    WHERE 
        (sp.plan_status = 'Accepted' OR sp.plan_status IS NULL)
    GROUP BY 
        u.id
    HAVING 
        COUNT(CASE WHEN ucre.exp_date > UNIX_TIMESTAMP() THEN 1 END) = 0 -- No active plans
        AND COUNT(CASE WHEN ucre.exp_date <= UNIX_TIMESTAMP() THEN 1 END) > 0 -- At least one expired plan
    ORDER BY 
        u.id
    LIMIT ? OFFSET ?;

    ");

    $stmt->bind_param("ii", $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        sendResponse(false, "Expired User Fetched!", $data);
    } else {
        sendResponse(true, "No user found!", null);
    }
    $stmt->close();
}else{
    sendResponse(true, "Invalid request type", null);
}

function sendResponse($error, $message, $data) {
    $response = [
        'error' => $error,
        'message' => $message,
        'resultData' => $data
    ];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}
?>