<?php
include "../connection.php";

if (isset($_POST["limit"])
 && isset($_POST["offset"])) {
    $limit = $_POST["limit"];
    $page = $_POST["offset"];

    $offset = ($page - 1) * $limit;

    $requestType = $_POST["reqType"];

    $stmt = $conn->prepare("SELECT 
    u.id AS userId, 
    sp.id AS planId,
    u.email, 
    u.user_name, 
    u.token, 
    sp.plan_type, 
    sp.plan_duration
    FROM 
        selected_plan sp
    LEFT JOIN 
        users u ON sp.uid = u.id
    WHERE
        sp.plan_status = 'Requested' AND sp.plan_type = ?
    LIMIT ? OFFSET ?;");

    $stmt->bind_param("sii", $requestType, $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        sendResponse(false, "All Subscription requests fetched", $data);
    } else {
        sendResponse(true, "No Subscription requests!", null);
    }
    $stmt->close();
}else{
    sendResponse(true, "Invalid request type", null);
}

function sendResponse($error, $message, $data) {
    $response = [
        'error' => $error,
        'message' => $message,
        'resultData' => $data
    ];
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}
?>