<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// require '../vendor/autoload.php';
require __DIR__ . '/../vendor/autoload.php';

function sendEmail($receiverName, $receiverEmail, $subject, $body, $conn) {

    $credentials = getEmailCredentials($conn);
    
    if (!$credentials) {
        return ['error' => true, 'message' => 'Email credentials not found'];
    }

    $mail = new PHPMailer(true);

    try {
        // Server settings
        $mail->isSMTP();
        $mail->Host       = 'smtp.gmail.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = $credentials['gmail'];
        $mail->Password   = $credentials['password'];
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;

        // Recipients
        $mail->setFrom($credentials['gmail'], 'StarsN IPTV Player');
        $mail->addAddress($receiverEmail, $receiverName);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;
        $mail->AltBody = strip_tags($body); // Plain text for non-HTML mail clients

        $mail->send();
        return ['error' => false, 'message' => 'Email has been sent'];
    } catch (Exception $e) {
        return ['error' => true, 'message' => "Email could not be sent. Mailer Error: {$mail->ErrorInfo}"];
    }
}

function getEmailCredentials($conn) {
    $query = "SELECT gmail, password FROM gmail_app_password LIMIT 1";
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        return mysqli_fetch_assoc($result);
    }
    
    return null;
}

?>
