<?php
include "connection.php";
require 'admin/send_mail.php';
header('Content-Type: application/json');

$response = [
    "error" => true,
    "message" => "Something went wrong, try again later!",
    "id" => -1,
];

try {
    if (!isset($_POST["email"], $_POST["userName"], $_POST["planType"], $_POST["planDuration"])) {
        throw new Exception("Invalid input");
    }

    $userName = $_POST["userName"];
    $email = $_POST["email"];
    $planType = $_POST["planType"];
    $planDuration = $_POST["planDuration"];
    $token = $_POST["token"];

    $checkIfUserExistStmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $checkIfUserExistStmt->bind_param("s", $email);
    $checkIfUserExistStmt->execute();
    $checkIfUserExistStmt->store_result();

    if ($checkIfUserExistStmt->num_rows > 0) {
        $checkIfUserExistStmt->bind_result($id);
        $checkIfUserExistStmt->fetch();
        $updateStmt = $conn->prepare("UPDATE users SET token = ? WHERE email = ?");
        $updateStmt->bind_param("ss", $token, $email);
        $updateResult = $updateStmt->execute();

        if ($updateResult) {
            // Only check for an existing "Trial" plan if the requested planType is "Trial"
            if ($planType === "Trial") {
                $trialCheckStmt = $conn->prepare("SELECT id FROM selected_plan WHERE uid = ? AND plan_type = 'Trial' AND plan_status = 'Accepted'");
                $trialCheckStmt->bind_param("i", $id);
                $trialCheckStmt->execute();
                $trialCheckStmt->store_result();

                if ($trialCheckStmt->num_rows > 0) {
                    // If an accepted "Trial" plan exists, return a message and stop further processing
                    $response = [
                        "error" => false,
                        "message" => "You have already availed the Trial offer.",
                        "id" => $id,
                    ];
                    echo json_encode($response);
                    exit(); // Exit the script to prevent further processing
                }
                $trialCheckStmt->close();
            }

            // Continue with existing flow if no accepted "Trial" plan is found
            $stmt = $conn->prepare("SELECT
                u.id AS userId,
                u.email,
                u.user_name,
                u.token
                FROM
                    users u
                LEFT JOIN
                    selected_plan sp ON u.id = sp.uid
                LEFT JOIN
                    user_credentials ucre ON ucre.upid = sp.id
                WHERE
                    (sp.plan_status = 'Accepted' OR sp.plan_status IS NULL) AND uid = ?
                GROUP BY
                    u.id
                HAVING
                    COUNT(CASE WHEN ucre.exp_date > UNIX_TIMESTAMP() THEN 1 END) = 0 -- No active plans
                    AND COUNT(CASE WHEN ucre.exp_date <= UNIX_TIMESTAMP() THEN 1 END) > 0 -- At least one expired plan
                ORDER BY
                    u.id");

            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $planStatus = "Requested";
                $planStmt = $conn->prepare("INSERT INTO selected_plan (uid, plan_type, plan_duration, plan_status) VALUES (?, ?, ?, ?)");
                $planStmt->bind_param("isss", $id, $planType, $planDuration, $planStatus);

                if ($planStmt->execute()) {

                    
                    $emailBody = createEmailBody($email, $userName);
                    $subject = 'IPTV Server Credentials Request';
                    // $emailSender = new EmailSender();
                    $emailResponse = $emailSender->sendEmail($email, $userName,$subject, $emailBody, $conn);
                   
                    if ($emailResponse['error']) {
                        $response = [
                            "error" => true,
                            "message" => $emailResponse['message'],
                            "id" =>$id
                        ];
                        exit(json_encode($response)); // Return the response in JSON format
                    } else {
                        $response = [
                            "error" => false,
                            "message" => "Account Creation Successfully!",
                            "id" => $id,
                        ];
                    }
                } else {
                    $response = [
                        "error" => true,
                        "message" => "Failed to create account at the moment, try again later!",
                        "id" => -1,
                    ];
                }
            } else {
                $response = [
                    "error" => false,
                    "message" => "You already have an account associated with this email address. Please use a different email to create a new account, or log in using your existing account.",
                    "id" => $id,
                ];
            }
        } else {
            $response = [
                "error" => true,
                "message" => "Failed to update token, try again later!",
                "id" => $id,
            ];
        }
    } else {
        // If the user does not exist, proceed to register a new account
        $registerUserStmt = $conn->prepare("INSERT INTO users (email, user_name, token) VALUES (?, ?, ?)");
        $registerUserStmt->bind_param("sss", $email, $userName, $token);

        if ($registerUserStmt->execute()) {
            $lastInsertId = $conn->insert_id;
            $planStatus = "Requested";
            $planStmt = $conn->prepare("INSERT INTO selected_plan (uid, plan_type, plan_duration, plan_status) VALUES (?, ?, ?, ?)");
            $planStmt->bind_param("isss", $lastInsertId, $planType, $planDuration, $planStatus);

            if ($planStmt->execute()) {
                // $emailSender = new EmailSender();
                // $emailResponse = $emailSender->sendEmail($email, $userName,$conn);
                $emailBody = createEmailBody($email, $userName);
                $subject = 'IPTV Server Credentials Request';
                // $emailSender = new EmailSender();
                $emailResponse = $emailSender->sendEmail($email, $userName,$subject, $emailBody, $conn);
                if ($emailResponse['error']) {
                    $response = [
                        "error" => true,
                        "message" => $emailResponse['message'],
                        "id" =>$lastInsertId
                    ];
                    exit(json_encode($response)); // Return the response in JSON format
                } else {
                    $response = [
                        "error" => false,
                        "message" => "User registered successfully!",
                        "id" => $lastInsertId,
                    ];
                }
                // $response = [
                //     "error" => false,
                //     "message" => "User registered successfully!",
                //     "id" => $lastInsertId,
                // ];
            } else {
                $response = [
                    "error" => true,
                    "message" => "Failed to create account at the moment, try again later!",
                    "id" => -1,
                ];
            }
        } else {
            throw new Exception("Failed to create account at the moment, try again later!");
        }

        $registerUserStmt->close();
    }

    $checkIfUserExistStmt->close();
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}


public function createEmailBody($receiverEmail, $receiverName) {
    // Prepare subject and body for the email
    $subject = 'Important: Your IPTV Credentials Notification';
    $body = "
    <html>
    <head>
        <title>IPTV Credentials Notification</title>
        <style>
            body { font-family: Arial, sans-serif; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; border: 1px solid #ccc; border-radius: 5px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <h2>Dear {$receiverName},</h2>
            <p>We would like to inform you that you will receive your IPTV server credentials within the next 30 minutes.</p>
            <p>If you have any questions, feel free to reach out to us.</p>
            <p>Best regards,<br>StarsN IPTV</p>
             <div class="footer">
                <p>&copy; ' . date('Y') . ' StarsN IPTV. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ";
}
 
?>
