<?php
include "connection.php";

header('Content-Type: application/json');

$response = [
    "error" => true,
    "message" => "Something went wrong, try again later!",
    "data" => null,
];

try {
    if (!isset($_POST["email"])) {
        throw new Exception("Email is required");
    }

    $email = $_POST["email"];

    // Prepare SQL statement to fetch user and multiple plan details, including the plan ID
    $stmt = $conn->prepare("SELECT 
                                u.id AS userId,
                                u.email,
                                u.user_name,
                                u.token,
                                sp.id AS plan_id,
                                sp.plan_type,
                                sp.plan_duration,
                                sp.plan_status
                            FROM 
                                users u
                            LEFT JOIN 
                                selected_plan sp ON u.id = sp.uid
                            WHERE 
                                u.email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Initialize user information structure with plans array
        $userInfo = [
            "userId" => null,
            "email" => null,
            "user_name" => null,
            "token" => null,
            "plans" => []
        ];

        while ($row = $result->fetch_assoc()) {
            if (!$userInfo["userId"]) {
                $userInfo["userId"] = $row["userId"];
                $userInfo["email"] = $row["email"];
                $userInfo["userName"] = $row["user_name"];
                $userInfo["token"] = $row["token"];
            }
            // Append each plan with the plan ID included
            $userInfo["plans"][] = [
                "planId" => $row["plan_id"],
                "planType" => $row["plan_type"],
                "planDuration" => $row["plan_duration"],
                "planStatus" => $row["plan_status"]
            ];
        }

        $response = [
            "error" => false,
            "message" => "Data retrieved successfully",
            "data" => $userInfo,
        ];
    } else {
        $response = [
            "error" => true,
            "message" => "No user found with the provided email",
            "data" => null,
        ];
    }

    $stmt->close();
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
