<?php
include "connection.php";

header('Content-Type: application/json');

$response = [
    "error" => true,
    "message" => "Something went wrong, try again later!",
    "data" => null,
];

try {
    if (!isset($_POST["uid"])) {
        throw new Exception("User ID (uid) is required");
    }

    $uid = $_POST["uid"];

    // Prepare SQL statement to fetch data based on uid
    $stmt = $conn->prepare("SELECT 
                                id, 
                                upid, 
                                acc_username, 
                                password, 
                                url, 
                                is_trial, 
                                created_at, 
                                exp_date 
                            FROM 
                                user_credentials 
                            WHERE 
                                upid = ?");
    
    $stmt->bind_param("i", $uid);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if user credentials exist
    if ($result->num_rows > 0) {
        $data = [];
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        $response = [
            "error" => false,
            "message" => "Data retrieved successfully",
            "data" => $data,
        ];
    } else {
        $response = [
            "error" => true,
            "message" => "No credentials found for the provided user ID",
            "data" => null,
        ];
    }

    $stmt->close();
} catch (Exception $e) {
    $response["message"] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
