<?php
include "connection.php";
require_once __DIR__ . '/vendor/autoload.php';
use Google\Auth\Credentials\ServiceAccountCredentials;
use Google\Auth\HttpHandler\HttpHandlerFactory;

class SendMessageFCM {
    private $credentialsKeyPath;
    private $scopes = 'https://www.googleapis.com/auth/firebase.messaging';
    private $conn;

    // Modify the constructor to accept a connection parameter
    function __construct($conn) {
        $this->credentialsKeyPath = __DIR__ . '/turbo-tribuzz-apps-daa06eced92e.json';
        $this->conn = $conn;
    }

    private function getAccessToken() {
        $jsonKey = file_get_contents($this->credentialsKeyPath);
        $serviceAccount = new ServiceAccountCredentials($this->scopes, $this->credentialsKeyPath);
        $accessTokenArray = $serviceAccount->fetchAuthToken(HttpHandlerFactory::build());
        if (!isset($accessTokenArray['access_token'])) {
            throw new Exception('Failed to get the access token.');
        }
        return $accessTokenArray['access_token'];
    }

    public function sendGCM($message, $token, $userName, $userId) {
        $url = 'https://fcm.googleapis.com/v1/projects/turbo-tribuzz-apps/messages:send';
        $fields = [
            'message' => [
                'token' => $token,
                'data' => [
                    'message' => $message,
                    'userName' => $userName,
                    'userId' => $userId
                ]
            ]
        ];
        $fields = json_encode($fields);
        $accessToken = $this->getAccessToken();
        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json'
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    public function sendMessageToAll() {
        $message = $_POST['message'];
        $userName = $_POST['userName'];
        $userId = $_POST['userId'];

        // Fetch all tokens from the `admin_tokens` table
        $query = "SELECT `token` FROM `admin_tokens`";
        $result = $this->conn->query($query);

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $token = $row['token'];
                $response = $this->sendGCM($message, $token, $userName, $userId);
                echo "Send message response to token $token: " . $response . "\n";
            }
        } else {
            echo "No tokens found in the database.";
        }
    }
}

// Pass the existing connection from connection.php to the SendMessageFCM class
$sendMessageFCM = new SendMessageFCM($conn);
$sendMessageFCM->sendMessageToAll();

?>
